;
;								EJEMPLO 13
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Dcada contadora UP/DOWN de un dgito
;
;Sobre el display 7 segmentos conectado a la puerta B se visualizar el nmero de pulsos 
;aplicados por la entrada RA0. RA1 determina si la cuenta es ascendente (a "1")
;o descendente
	
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos
 
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                   
Contador			equ	0x20			;Variable del contador

					org	0x00			;Vector de RESET
					goto	Inicio
					org	0x05

;**********************************************************************************
;Tabla: Esta rutina convierte el cdigo BCD presente en los 4 bits de menos peso
;del reg. W en su equivalente a 7 segmentos. El cdigo 7 segmentos retorna tambin
;en el reg. W

Tabla:			addwf	PCL,F			;Desplazamiento sobre la tabla
				retlw	b'00111111'		;Dgito 0
				retlw	b'00000110'		;Dgito 1
				retlw	b'01011011'		;Dgito 2
				retlw	b'01001111'		;Dgito 3
				retlw	b'01100110'		;Dgito 4
				retlw	b'01101101'		;Dgito 5
				retlw	b'01111101'		;Dgito 6
				retlw	b'00000111'		;Dgito 7
				retlw	b'01111111'		;Dgito 8
				retlw	b'01100111'		;Dgito 9

;*********************************************************************************
;Delay_10_ms: Esta rutina de temporizacin tiene por objeto eleiminar el "efecto
;rebote" de los perifricos electromecnicos. Ha sido empleada en anteriores ejemplos

Delay_10_ms:	bcf		INTCON,T0IF		;Desconecta el flag de rebosamiento
				movlw	~.39		
				movwf	TMR0			;carga el TMR0 con 39
Delay_10_ms_1	btfss	INTCON,T0IF		;Rebasamiento del TMR0 ??
				goto	Delay_10_ms_1	;Todava no
				bcf		INTCON,T0IF		;Ahora si, reponer el flag
				return

Inicio	       	clrf 	PORTB			;Borra los latch de salida
				bsf		STATUS,RP0		;Selecciona banco 1
				clrf	TRISB			;Puerta B se configura como salida
				movlw	0x06	
				movwf	ADCON1			;Puerta A digital
				movlw	b'00111111'		
				movwf	TRISA			;Puerta A se configura como entrada		
				movlw	b'00000111'
				movwf	OPTION_REG		;Preescaler de 256 para el TMR0
				bcf		STATUS,RP0		;Selecciona banco 0			                                                                         
				clrf	Contador		;Puesta a 0 del contador
				
Loop			movf	Contador,W
				call	Tabla			;Convierte BCD a 7 segmentos
				movwf	PORTB			;Visualiza el valor del contador
Wait_0			btfsc	PORTA,0			;Bajada de la seal RA0 ?
				goto	Wait_0			;No
				call	Delay_10_ms		;Elimina rebotes

Wait_1			btfss	PORTA,0			;Subida de RA0 (pulso) ??
				goto	Wait_1			;No
				call	Delay_10_ms		;Ha habido pulso (1-0-1), eliminar rebotes

				btfss	PORTA,1			;RA1 = 1
				goto	Down			;No, cuenta descendente

Up				incf	Contador,F		;Incrementa contador
				movlw	.10
				subwf	Contador,W
				btfss	STATUS,Z		;Es  mayor de 9 ??
				goto	Loop			;No
				clrf	Contador		;Si, puesta a 0 del contador
				goto	Loop

Down			decf	Contador,F		;Decrementa el contador
				movlw	0xff
				subwf	Contador,W
				btfss	STATUS,Z		;Es menor de 0 ??
				goto	Loop			;No
				movlw	0x09
				movwf	Contador		;Si, puesta a 9 del contador
				goto	Loop

				end						;Fin del programa fuente

